/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.NextTurnBlockPower;

public class DodgeAndRoll
extends AbstractCard {
    public static final String ID = "Dodge and Roll";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Dodge and Roll");
    public static final String NAME = DodgeAndRoll.cardStrings.NAME;
    public static final String DESCRIPTION = DodgeAndRoll.cardStrings.DESCRIPTION;
    private static final int COST = 1;
    private static final int BLOCK_INIT_GAINED = 4;
    private static final int POOL = 1;

    public DodgeAndRoll() {
        super(ID, NAME, "green/skill/dodgeRoll", "green/skill/dodgeAndRoll", 1, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.SELF, 1);
        this.baseBlock = 4;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new GainBlockAction(p, p, this.block));
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(p, p, new NextTurnBlockPower(p, this.block), this.block));
    }

    @Override
    public AbstractCard makeCopy() {
        return new DodgeAndRoll();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeBlock(2);
        }
    }
}

